/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.Instrument;
import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ConnectPanel
extends QDPanel {
    private QDLabel m_instrId;
    private QDButton m_connect;
    private JComponent m_owner;
    private RemoteInstrument m_instr = null;
    private InstrumentListener m_listener = null;
    private InstrumentListener m_myListener;

    public ConnectPanel(JComponent jComponent) {
        this.m_owner = jComponent;
        this.initComponents();
        this.m_myListener = new InstrumentListener(){

            public void connected(RemoteInstrument remoteInstrument) {
                ConnectPanel.this.checkConnection(remoteInstrument);
            }

            public void disconnected(RemoteInstrument remoteInstrument) {
                if (remoteInstrument == ConnectPanel.this.m_instr) {
                    ConnectPanel.this.m_instr = null;
                    ConnectPanel.this.connectionChanged();
                    ConnectPanel.this.notifyDisconnected();
                }
            }
        };
        Instrument.addListener(this.m_myListener);
        RemoteInstrument remoteInstrument = Instrument.getDefault();
        if (remoteInstrument != null) {
            this.checkConnection(remoteInstrument);
        } else {
            this.connectionChanged();
        }
    }

    public void close() {
        this.m_instr = null;
        Instrument.removeListener(this.m_myListener);
        Instrument.unregister(this.m_owner);
    }

    private void checkConnection(RemoteInstrument remoteInstrument) {
        if (this.m_instr == null) {
            this.m_instr = remoteInstrument;
            Instrument.register(this.m_owner, remoteInstrument);
        }
        if (this.m_instr == remoteInstrument) {
            this.connectionChanged();
            this.notifyConnected();
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        QDLabel qDLabel = new QDLabel("Instrument: ");
        qDLabel.setForeground(QDStdUI.getActionForeground());
        this.add((Component)qDLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.m_instrId = new QDLabel("  ");
        this.m_instrId.setToolTipText("The current instrument connection");
        this.add((Component)this.m_instrId, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        ++gridBagConstraints.gridx;
        this.m_connect = new QDButton("Connect");
        this.m_connect.addActionListener((ActionListener)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectPanel.this.connect();
            }
        });
        this.m_connect.setToolTipText("Connect to an Instrument");
        this.add((Component)this.m_connect, gridBagConstraints);
        this.useCompactForm(false);
    }

    public void useCompactForm(boolean bl) {
        if (bl) {
            this.m_connect.setIcon(null);
            this.m_connect.useSmallFont(true);
        } else {
            this.m_connect.useSmallFont(false);
            this.m_connect.setIcon((Icon)QDUtil.loadIcon((String)"connect.png"));
        }
    }

    public void setEnabled(boolean bl) {
        this.m_connect.setEnabled(bl);
    }

    public void setListener(InstrumentListener instrumentListener) {
        this.m_listener = instrumentListener;
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        RemoteInstrument remoteInstrument2 = this.m_instr;
        this.m_instr = remoteInstrument;
        this.connectionChanged();
        if (remoteInstrument == null) {
            if (remoteInstrument2 != null) {
                remoteInstrument2.disconnect();
            }
            Instrument.unregister(this.m_owner);
            this.notifyDisconnected();
        } else {
            Instrument.register(this.m_owner, remoteInstrument);
            this.notifyConnected();
        }
    }

    public RemoteInstrument getInstrument() {
        return this.m_instr;
    }

    private void connect() {
        RemoteInstrument remoteInstrument = Instrument.connect(this.m_owner);
        if (remoteInstrument == null) {
            return;
        }
        this.m_instr = remoteInstrument;
    }

    private void notifyConnected() {
        if (this.m_listener != null) {
            this.m_listener.connected(this.m_instr);
        }
    }

    private void notifyDisconnected() {
        if (this.m_listener != null) {
            this.m_listener.disconnected(this.m_instr);
        }
    }

    private void connectionChanged() {
        boolean bl;
        boolean bl2 = bl = this.m_instr != null && this.m_instr.isConnected();
        if (!bl) {
            this.m_instrId.setText("Not Connected");
            return;
        }
        try {
            String string = Instrument.getUnitType(this.m_instr);
            if (string == null) {
                MsgLog.error("Unable to ID the instrument");
                this.m_instrId.setText(this.m_instr.getConnection().getName());
            } else {
                this.m_instrId.setText(string + " @ " + this.m_instr.getConnection().getName());
            }
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error(instrumentException.getMessage());
        }
    }
}

